package com.bumptech.glide;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bumptech.glide.integration.avif.AvifGlideModule;
import com.bumptech.glide.integration.okhttp3.OkHttpLibraryGlideModule;
import com.github.penfeizhou.animation.glide.GlideAnimationModule;
import expo.modules.image.ExpoImageAppGlideModule;
import expo.modules.image.blurhash.BlurhashModule;
import expo.modules.image.dataurls.Base64Module;
import expo.modules.image.decodedsource.DecodedModule;
import expo.modules.image.okhttp.ExpoImageOkHttpClientGlideModule;
import expo.modules.image.svg.SVGModule;
import expo.modules.image.thumbhash.ThumbhashModule;
import java.util.Collections;
import java.util.Set;

@SuppressWarnings("deprecation")
final class GeneratedAppGlideModuleImpl extends GeneratedAppGlideModule {
  private final ExpoImageAppGlideModule appGlideModule;

  public GeneratedAppGlideModuleImpl(Context context) {
    appGlideModule = new ExpoImageAppGlideModule();
    if (Log.isLoggable("Glide", Log.DEBUG)) {
      Log.d("Glide", "Discovered AppGlideModule from annotation: expo.modules.image.ExpoImageAppGlideModule");
      Log.d("Glide", "Discovered LibraryGlideModule from annotation: com.bumptech.glide.integration.avif.AvifGlideModule");
      Log.d("Glide", "Discovered LibraryGlideModule from annotation: com.bumptech.glide.integration.okhttp3.OkHttpLibraryGlideModule");
      Log.d("Glide", "Discovered LibraryGlideModule from annotation: com.github.penfeizhou.animation.glide.GlideAnimationModule");
      Log.d("Glide", "Discovered LibraryGlideModule from annotation: expo.modules.image.blurhash.BlurhashModule");
      Log.d("Glide", "Discovered LibraryGlideModule from annotation: expo.modules.image.dataurls.Base64Module");
      Log.d("Glide", "Discovered LibraryGlideModule from annotation: expo.modules.image.decodedsource.DecodedModule");
      Log.d("Glide", "Discovered LibraryGlideModule from annotation: expo.modules.image.okhttp.ExpoImageOkHttpClientGlideModule");
      Log.d("Glide", "Discovered LibraryGlideModule from annotation: expo.modules.image.svg.SVGModule");
      Log.d("Glide", "Discovered LibraryGlideModule from annotation: expo.modules.image.thumbhash.ThumbhashModule");
    }
  }

  @Override
  public void applyOptions(@NonNull Context context, @NonNull GlideBuilder builder) {
    appGlideModule.applyOptions(context, builder);
  }

  @Override
  public void registerComponents(@NonNull Context context, @NonNull Glide glide,
      @NonNull Registry registry) {
    new AvifGlideModule().registerComponents(context, glide, registry);
    new OkHttpLibraryGlideModule().registerComponents(context, glide, registry);
    new GlideAnimationModule().registerComponents(context, glide, registry);
    new BlurhashModule().registerComponents(context, glide, registry);
    new Base64Module().registerComponents(context, glide, registry);
    new DecodedModule().registerComponents(context, glide, registry);
    new ExpoImageOkHttpClientGlideModule().registerComponents(context, glide, registry);
    new SVGModule().registerComponents(context, glide, registry);
    new ThumbhashModule().registerComponents(context, glide, registry);
    appGlideModule.registerComponents(context, glide, registry);
  }

  @Override
  public boolean isManifestParsingEnabled() {
    return appGlideModule.isManifestParsingEnabled();
  }

  @Override
  @NonNull
  public Set<Class<?>> getExcludedModuleClasses() {
    return Collections.emptySet();
  }

  @Override
  @NonNull
  GeneratedRequestManagerFactory getRequestManagerFactory() {
    return new GeneratedRequestManagerFactory();
  }
}
